//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Item {
    id : scrollBar

    property real size : .1
    property real position : 0

    readonly property alias pressed : mouseArea.pressed

    signal scrollRequested(real position)

    implicitWidth : 12
    implicitHeight : 100

    MouseArea {
        id : mouseArea

        acceptedButtons : Qt.LeftButton
        preventStealing : true
        anchors.fill : scrollBar
        hoverEnabled : true

        onPressed : {
            const handlePos = handle.mapFromItem(scrollBar, mouse.x, mouse.y);
            if (!handle.contains(handlePos)) {
                const scrollPos = mouse.y / Math.max(1.0, height);
                scrollBar.scrollRequested(
                            Math.max(0, Math.min(1, scrollPos)));
                handle.lowerBound = handle.height * scrollPos;
                handle.upperBound =
                        scrollBar.height - handle.height * (1.0 - scrollPos);
            } else {
                const clickPos = handlePos.y / handle.height;
                handle.lowerBound = handle.height * clickPos;
                handle.upperBound =
                        scrollBar.height - handle.height * (1.0 - clickPos);
            }
        }
        onPositionChanged : {
            if (!pressed)
                return;

            const scrollPos = (mouse.y - handle.lowerBound) /
                    (handle.upperBound - handle.lowerBound);
            scrollBar.scrollRequested(Math.max(0, Math.min(1, scrollPos)));
        }
    }

    Rectangle {
        id : handle

        property int upperBound : 0
        property int lowerBound : 0

        anchors {
            left : scrollBar.left
            right : scrollBar.right
        }

        color : UiColors.getColor(UiColors.HeaderGrey4)
        height : Math.max(20, Math.min(1.0, scrollBar.size) * scrollBar.height)

        y : (scrollBar.height - handle.height) * scrollBar.position

        border {
            width : 1
            color : UiColors.getColor(UiColors.DisabledLightGrey13)
        }
    }
}
